#ifndef RXINTERRUPT_H_
#define RXINTERRUPT_H_

#include "network.h"

#define MAX_MSG_LENGTH 128
//Key definitions
#define LEFT_ARROW 0x6B
#define RIGHT_ARROW 0x74
#define UP_ARROW 0x75
#define DOWN_ARROW 0x72
#define SPACEBAR 0x29
#define ENTER 0x5A
#define LEFT_ARROW_NET 0xB6
#define SPACEBAR_NET 0xC2
#define RIGHT_ARROW_NET 0x47
#define UP_ARROW_NET 0x57
#define DOWN_ARROW_NET 0x27
#define PLUS_SIGN 0x3d
#define PAGE_UP 0x7d
#define PAGE_DOWN 0x7a
#define END 0x69
#define HOME 0x6c
#define DEL 0x71
#define F1 0x16
#define F2 0x1E
#define F3 0x26
#define F4 0x25

#define PLAYER_NUMBER 1

unsigned int receive_buffer_length;
unsigned char receive_buffer[1600];
short second_packet_ready = 0;
short terrainReceived = 0;
alt_u8 remoteKey = 0;

static void ethernet_interrupt_handler() {
  unsigned int receive_status;
  int i;
  
  receive_status = ReceivePacket(receive_buffer, &receive_buffer_length);

  if (receive_status == DMFE_SUCCESS) {
    printf("\n\nReceive Packet Length = %d\n", receive_buffer_length);
    
    // Gets the terrain-redraw code from the packet creator.      
    unsigned int code = receive_buffer[UDP_PACKET_PAYLOAD_OFFSET];
        
    
    // Redraw first half of the terrain
    if (code == TERRAIN_REDRAW_1){
        float terrainT[641];
        read_terrain(terrainT, s, receive_buffer, receive_buffer_length, code);
        printf("\n\nTerrain 1 Packet Length = %d\n", receive_buffer_length);
    } 
    // Redraw the second half of the terrain
    else if (code == TERRAIN_REDRAW_2){
        float terrainT[641];
        read_terrain(terrainT,s, receive_buffer, receive_buffer_length, code);
        printf("\n\nTerrain 2 Packet Length = %d\n", receive_buffer_length);              
    } 
    // Means first half of the terrain has been processed
    else if (code == TERRAIN_REDRAW_RECEIVE_1){
        second_packet_ready = 1;
    }
    else if (code == TERRAIN_REDRAW_RECEIVE_2){
        second_packet_ready = 0;
        terrainReceived = 1;
    }
    else{
        remoteKey = receive_buffer[UDP_PACKET_PAYLOAD_OFFSET+1];
        printf("%x\n", remoteKey);
        
        switch(remoteKey){
         
         case LEFT_ARROW:
            printf("Left Arrow\n");
         break;
         
         case RIGHT_ARROW:
            printf("Right Arrow\n");
         break;   
        }
    }
                         
    
    printf("Packet received correctly\n");
  } else {
    printf("Error receiving packet\n");
  }

  usleep(STD_DELAY);
  dm9000a_iow(ISR, 0x3F);
              
  /* Re-enable DM9000A interrupts */
  dm9000a_iow(IMR, INTR_set);
}

short getTerrainSent(){
    return terrainReceived;
}

alt_u8 getRemoteKey(){
    alt_u8 tempKey = remoteKey;
    remoteKey = 0x00;    
    return tempKey;    
}

void initializeEthernet()
{
  DM9000_init(mac_address);
  alt_irq_register(DM9000A_IRQ, NULL, (void*)ethernet_interrupt_handler); 
}
#endif /*RXINTERRUPT_H_*/
